IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_CotRemAut_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_CotRemAut_TX
END
GO

CREATE FUNCTION [dbo].[CF_CotRemAut_TX](@pId_Trans INT, @pEmpresa_Cuit_Origen VARCHAR(11), @pEmpresa_Razon_Social_Origen VARCHAR(100), @pEmpresa_Direccion_Origen	VARCHAR(100), @pEmpresa_Cp_Origen VARCHAR(10)) 
RETURNS CHAR(706)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			CHAR(706) /*663 de caracteres + 43 delimitadores*/
/*FIN Variable de Retorno*/

/*Declaracion de Variables Archivo*/
DECLARE @Delimitador						CHAR(1)
DECLARE @REA_Tipo_Registro					CHAR(2) /*Ini: 001 Fin: 002. Validacion: Al menos 1 registro 02. Comentarios: '02'=Remito*/
DECLARE @REA_Fecha_Emision					CHAR(8) /*Ini: 003 Fin: 010. Validacion: Valido en el formato especificado. Comentarios: . Obligatorio: SI.*/
DECLARE @REA_Codigo_Unico					CHAR(16)/*Ini: 011 Fin: 026. Validacion: (3 pos. CODIGO_AFIP: Valido segun tabla de Comprobantes, campo CODIGO_AFIP | 5 pos. PREFIJO: numerico >= 0 | 8 pos. NUMERO: numerico>0). Comentarios: (3 pos. CODIGO_AFIP + 5 pos. PREFIJO + 8 pos. NUMERO). Obligatorio: SI.*/
DECLARE @REA_Fecha_Salida_Transporte		CHAR(8) /*Ini: 027 Fin: 034. Validacion: Fecha >= fecha de emision y >= hoy menos uno y <= hoy mas treinta. Comentarios: AAAAMMDD. Obligatorio: SI.*/
DECLARE @REA_Hora_Salida_Transporte			CHAR(4) /*Ini: 035 Fin: 038. Validacion: -. Comentarios: HHMM. Obligatorio: NO.*/
DECLARE @REA_Sujeto_Generador				CHAR(1) /*Ini: 039 Fin: 039. Validacion: Valores posibles: E (emisor), D (destinatario). Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Destinatario_Consumidor_Final	CHAR(1) /*Ini: 040 Fin: 040. Validacion: 0 = NO / 1 = SI. Comentarios: Nota: Si es CONSUMIDOR_FINAL e IMPORTE >= $5.000, debe proporcionar los campos DESTINATARIO_TIPO_DOCUMENTO y DESTINATARIO_DOCUMENTO o DESTINATERIO_CUIT. A su vez informar el campo DESTINATARIO_RAZON_SOCIAL. Obligatorio: SI.*/
DECLARE @REA_Destinatario_Tipo_Documento	CHAR(3) /*Ini: 041 Fin: 043. Validacion: Requerido si documento es distinto de blanco. Valores posibles: 'DNI', 'LC', 'LE', 'PAS', 'CI'. Comentarios: (VER NOTA del campo DESTINARIO_CONSUMIDOR_FINAL). Obligatorio: NO.*/
DECLARE @REA_Destinatario_Documento			CHAR(11)/*Ini: 044 Fin: 054. Validacion: Valores posibles: blanco o numero > 0. Comentarios: (VER NOTA del campo DESTINARIO_CONSUMIDOR_FINAL). Obligatorio: NO.*/
DECLARE @REA_Destinatario_Cuit				CHAR(11)/*Ini: 055 Fin: 065. Validacion: Valido Segun Rutina Standard. Requerido si cosumidor final=0. Si SUJETO_GENERADOR = D debe ser igual a CUIT_EMPRESA. Comentarios: (VER NOTA del campo DESTINARIO_CONSUMIDOR_FINAL). Obligatorio: NO.*/
DECLARE @REA_Destinatario_Razon_Social		CHAR(50)/*Ini: 066 Fin: 115. Validacion: Requerido si consumidor final = 0. Comentarios: (VER NOTA del campo DESTINARIO_CONSUMIDOR_FINAL). Obligatorio: NO.*/
DECLARE @REA_Destinatario_Tenedor			CHAR(1) /*Ini: 116 Fin: 116. Validacion: 0=NO / 1=SI. Si DESTINATARIO_CONSUMIDOR_FINAL=1 entonces DESTINATARIO_TENEDOR=0. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Destino_Domicilio_Calle		CHAR(40)/*Ini: 117 Fin: 156. Validacion: -. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Destino_Domicilio_Numero		CHAR(5) /*Ini: 157 Fin: 161. Validacion: >0 si DESTINO_DOMICILIO_COMPLE distinto de S/N =0 (cero) o   (blanco) si DESTINO_DOMICILIO_COMPLE=S/N. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Destino_Domicilio_Comple		CHAR(5) /*Ini: 162 Fin: 166. Validacion: Valores posibles: ' ', 'S/N', '1/2', '1/4', 'BIS'. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Destino_Domicilio_Piso			CHAR(3) /*Ini: 167 Fin: 169. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Destino_Domicilio_Dto			CHAR(4) /*Ini: 170 Fin: 173. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Destino_Domicilio_Barrio		CHAR(30)/*Ini: 174 Fin: 203. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Destino_Domicilio_CodigoPostal	CHAR(8) /*Ini: 204 Fin: 211. Validacion: -. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Destino_Domicilio_Localidad	CHAR(50)/*Ini: 212 Fin: 261. Validacion: -. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Destino_Domicilio_Provincia	CHAR(1) /*Ini: 262 Fin: 262. Validacion: Valido segun Tabla de Provincias. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Propio_Destino_Domicilio_Codigo CHAR(20)/*Ini: 263 Fin: 282. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Entrega_Domicilio_Origen		CHAR(2) /*Ini: 283 Fin: 284. Validacion: Valores posibles SI, NO. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Origen_Cuit					CHAR(11)/*Ini: 285 Fin: 295. Validacion: Valido Segun Rutina Standard. Si SUJETO_GENERADOR = 'E' debe ser igual a CUIT_EMPRESA. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Origen_Razon_Social			CHAR(50)/*Ini: 296 Fin: 345. Validacion: -. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Emisor_Tenedor					CHAR(1) /*Ini: 346 Fin: 346. Validacion: 0=NO / 1=SI. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Origen_Domicilio_Calle			CHAR(40)/*Ini: 347 Fin: 386. Validacion: -. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Origen_Domicilio_Numero		CHAR(5) /*Ini: 387 Fin: 391. Validacion: >0 si ORIGEN_DOMICILIO_COMPLE distinto de 'S/N' =0 (cero) o ' ' (blanco) si ORIGEN_DOMICILIO_COMPLE ='S/N'. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Origen_Domicilio_Comple		CHAR(5) /*Ini: 392 Fin: 396. Validacion: Valores posibles: ' ', 'S/N', '1/2', '1/4', 'BIS'. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Origen_Domicilio_Piso			CHAR(3) /*Ini: 397 Fin: 399. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Origen_Domicilio_Dto			CHAR(4) /*Ini: 400 Fin: 403. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Origen_Domicilio_Barrio		CHAR(30)/*Ini: 404 Fin: 433. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Origen_Domicilio_CodigoPostal	CHAR(8) /*Ini: 434 Fin: 441. Validacion: -. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Origen_Domicilio_Localidad		CHAR(50)/*Ini: 442 Fin: 491. Validacion: -. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Origen_Domicilio_Provincia		CHAR(1) /*Ini: 492 Fin: 492. Validacion: Valido segun Tabla de Provincias. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Transportista_Cuit				CHAR(11)/*Ini: 493 Fin: 503. Validacion: Valido Segun Rutina Standard. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Tipo_Recorrido					CHAR(1) /*Ini: 504 Fin: 504. Validacion: Valores posibles: 'U', 'R', 'M' o ' ' (URBANO, RURAL, MIXTO, en blanco). Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Recorrido_Localidad			CHAR(50)/*Ini: 505 Fin: 554. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Recorrido_Calle				CHAR(40)/*Ini: 555 Fin: 594. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Recorrido_Ruta					CHAR(40)/*Ini: 595 Fin: 634. Validacion: -. Comentarios: -. Obligatorio: NO.*/
DECLARE @REA_Patente_Vehiculo				CHAR(7) /*Ini: 635 Fin: 641. Validacion: Requerido si TRANSPORTISTA_CUIT = CUIT_EMPRESA. Comentarios: 3 letras y 3 numeros o 2 letras, 3 numeros y 2 letras. Obligatorio: NO.*/
DECLARE @REA_Patente_Acoplado				CHAR(7) /*Ini: 642 Fin: 648. Validacion: -. Comentarios: 3 letras y 3 numeros o 2 letras, 3 numeros y 2 letras. Obligatorio: NO.*/
DECLARE @REA_Producto_No_Term_Dev			CHAR(1) /*Ini: 649 Fin: 649. Validacion: Productos no terminados / devoluciones: 0=NO / 1=SI. Comentarios: -. Obligatorio: SI.*/
DECLARE @REA_Importe						CHAR(14)/*Ini: 650 Fin: 663. Validacion: Obligatorio siempre o sea > 0 (cero), salvo si campo PRODUCTO_NO_TERM_DEV = 1 o cuando ORIGEN_CUIT = DESTINATARIO_CUIT, que se permite 0 (cero) o blanco. Importe Neto de componente tributario. Comentarios: 12 enteros y 2 decimales. Las ultimnas 2 posiciones se toman como decimales siempre. Obligatorio: SI.*/
/*FIN Declaracion de Variables Archivo*/

/*Declaracion de Variables Locales*/
DECLARE @Id_Tipo_Cbte				CHAR(4)
DECLARE @Codigo_DGI					CHAR(3)
DECLARE @Tipo_Cbte					CHAR(2)
DECLARE @Id_Sucursal				CHAR(5)
DECLARE @Comprobante_Nro			CHAR(8)
DECLARE @Id_Cliente					INT
DECLARE @Id_Cliente_CF				INT
DECLARE @BaseDatosMaster			VARCHAR(40)
DECLARE @NombBaseDatos				VARCHAR(128)
DECLARE @QueryBD					VARCHAR(255)
DECLARE @Empresa_Id_Localidad		SMALLINT
DECLARE @Empresa_Id_Provincia		SMALLINT
DECLARE @Id_Transportista			INT
DECLARE @Transportista_Cuit			VARCHAR(13)
DECLARE @Suc_Destina				SMALLINT
/*FIN Declaracion de Variables Locales*/

SET @Delimitador = '|'

/*Asignacion de Variables Locales*/
SET @Id_Tipo_Cbte	= ISNULL((SELECT Id_Tipo_Cbte FROM Cbtes WHERE Id_Trans = @pId_Trans), '')
SET @Codigo_DGI		= ISNULL((SELECT RIGHT('000' + CAST(Id_AR_ARBA_COT_CbteTipo AS VARCHAR), 3) FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte), '000')
SET @Tipo_Cbte		= ISNULL((SELECT Letra FROM AR_ARBA_COT_Cbtes_Tipos WHERE Id_AR_ARBA_COT_CbteTipo = @Codigo_DGI), '  ')
SET @Id_Sucursal	= ISNULL((SELECT RIGHT('00000' + CAST(Id_Sucursal AS VARCHAR), 5)FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte), '00000')
SET @Comprobante_Nro = ISNULL((SELECT RIGHT('00000000' + CAST(Comprobante_Nro AS VARCHAR), 8)FROM Cbtes WHERE Id_Trans = @pId_Trans), '00000000')
SET @Id_Cliente		= ISNULL((SELECT Id_Cliente FROM Cbtes WHERE Id_Trans = @pId_Trans), 0)
SET @Id_Cliente_CF	= ISNULL((SELECT dbo.CF_xParam('Id_Cliente_CF')), 1)

SET @BaseDatosMaster = (SELECT dbo.CF_xParam('BD_Master'))
SET @NombBaseDatos	= (SELECT DB_NAME())

/*IF EXISTS(SELECT * FROM ##z_tmp_Empresa_SP)
BEGIN
  DROP TABLE ##z_tmp_Empresa_SP
END

SET @QueryBD		= '(SELECT Cuit, Razon_Social, Direccion, Cp, Id_Localidad, Id_Provincia INTO ##z_tmp_Empresa_SP FROM ' + @BaseDatosMaster + '.dbo.Empresas WHERE Nombre_DB = ''' + @NombBaseDatos + ''')'
EXEC(@QueryBD)

SET @Empresa_Id_Localidad	= ISNULL((SELECT Id_Localidad FROM ##z_tmp_Empresa_SP), 0)
SET @Empresa_Id_Provincia	= ISNULL((SELECT Id_Provincia FROM ##z_tmp_Empresa_SP), 0)

IF EXISTS(SELECT * FROM ##z_tmp_Empresa_SP)
BEGIN
  DROP TABLE ##z_tmp_Empresa_SP
END*/

SET @Id_Transportista	= ISNULL((SELECT Id_Transportista FROM Cbtes WHERE Id_Trans = @pId_Trans), 0)
SET @Transportista_Cuit = ISNULL((SELECT Cuit FROM Proveedores WHERE Id_Proveedor = @Id_Transportista),'00000000000')
SET @Suc_Destina		= (SELECT ISNULL(Suc_Destina, 0) FROM Cbtes WHERE Id_Trans = @pId_Trans)
/*FIN Asignacion de Variables Locales*/

/*Asignacion de Variables Archivo*/

SET @REA_Tipo_Registro = '02'

SET @REA_Fecha_Emision =	(SELECT CAST(DATEPART(YY, Fecha) AS CHAR(4)) + 
							RIGHT('00' + CAST(DATEPART(mm, Fecha) AS VARCHAR),2) + 
							RIGHT('00' + CAST(DATEPART(dd, Fecha) AS VARCHAR),2)
							FROM Cbtes
							WHERE 
							Id_Trans = @pId_Trans)

SET @REA_Codigo_Unico = @Codigo_DGI + @Id_Sucursal + @Comprobante_Nro


SET @REA_Fecha_Salida_Transporte = (SELECT CAST(DATEPART(YY, Fecha_Estimada) AS CHAR(4)) + 
									RIGHT('00' + CAST(DATEPART(mm, Fecha_Estimada) AS VARCHAR),2) + 
									RIGHT('00' + CAST(DATEPART(dd, Fecha_Estimada) AS VARCHAR),2)
									FROM Cbtes
									WHERE 
									Id_Trans = @pId_Trans)

SET @REA_Hora_Salida_Transporte =	(SELECT RIGHT('00' + CAST(DATEPART(HH, Fecha_Estimada) AS CHAR(2)), 2) + 
									RIGHT('00' + CAST(DATEPART(MINUTE, Fecha_Estimada) AS VARCHAR),2)
									FROM Cbtes
									WHERE 
									Id_Trans = @pId_Trans)

SET @REA_Sujeto_Generador = 'E'

IF(@Id_Cliente = @Id_Cliente_CF)
BEGIN
	SET @REA_Destinatario_Consumidor_Final = '1'
END
ELSE
BEGIN
	SET @REA_Destinatario_Consumidor_Final = '0'
END

SET @REA_Destinatario_Tipo_Documento = '   '

SET @REA_Destinatario_Documento = '           '

IF(@REA_Destinatario_Consumidor_Final = '0')
BEGIN
	SET @REA_Destinatario_Cuit = ISNULL((SELECT RIGHT('00000000000' + CAST(Cuit AS VARCHAR), 11) FROM Clientes WHERE Id_Cliente = @Id_Cliente), '00000000000')	
END
ELSE
BEGIN
	SET @REA_Destinatario_Cuit = '           '
END

IF(@REA_Destinatario_Consumidor_Final = '0')
BEGIN
	SET @REA_Destinatario_Razon_Social = (SELECT SUBSTRING(RTRIM(LTRIM(Razon_Social)), 0, 50) FROM Clientes WHERE Id_Cliente = @Id_Cliente)
END
ELSE
BEGIN
	SET @REA_Destinatario_Razon_Social = '                                                  '
END

IF(@REA_Destinatario_Consumidor_Final = '1')
BEGIN
	SET @REA_Destinatario_Tenedor = '0'
END
ELSE
BEGIN
	SET @REA_Destinatario_Tenedor = '1' /*Ver que es tenedor*/
END

IF(@Suc_Destina <> 0)
BEGIN
	/*Saca la informacion de Clientes_Suc*/
	SET @REA_Destino_Domicilio_Calle = ISNULL((SELECT SUBSTRING(RTRIM(LTRIM(Direccion)), 0, 40) FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '                                        ')
	SET @REA_Destino_Domicilio_Numero = ISNULL((SELECT RIGHT('00000' + CAST(Dir_Entrega_Numero AS VARCHAR), 5) FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '00000')
	SET @REA_Destino_Domicilio_Comple = ISNULL((SELECT Id_AR_ARBA_COT_Tipo_Dom_Nro FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '     ') 
	SET @REA_Destino_Domicilio_Piso = ISNULL((SELECT Dir_Entrega_Piso FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '   ')
	SET @REA_Destino_Domicilio_Dto = ISNULL((SELECT Dir_Entrega_Dto FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '    ')
	SET @REA_Destino_Domicilio_Barrio = ISNULL((SELECT Dir_Entrega_Barrio FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '                              ')
	SET @REA_Destino_Domicilio_CodigoPostal = ISNULL((SELECT CP FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina) , '        ')
	SET @REA_Destino_Domicilio_Localidad = ISNULL((SELECT Localidad_Descrip FROM Clientes_Suc WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '                                                  ')
	SET @REA_Destino_Domicilio_Provincia = ISNULL((SELECT TP.Id_AR_ARBA_COT_TProv FROM Clientes_Suc CS, Tab_Provincias TP WHERE CS.Id_Provincia = TP.Id_Provincia AND CS.Id_Cliente = @Id_Cliente AND CS.Nro = @Suc_Destina), 'C'/*Capital Federal*/)
END
ELSE
BEGIN
	/*Saca la informacion de Clientes*/
	SET @REA_Destino_Domicilio_Calle = ISNULL((SELECT SUBSTRING(RTRIM(LTRIM(Direccion)), 0, 40) FROM Clientes WHERE Id_Cliente = @Id_Cliente), '                                        ')
	SET @REA_Destino_Domicilio_Numero = ISNULL((SELECT RIGHT('00000' + CAST(Dir_Entrega_Numero AS VARCHAR), 5) FROM Clientes WHERE Id_Cliente = @Id_Cliente), '00000')
	SET @REA_Destino_Domicilio_Comple = ISNULL((SELECT Id_AR_ARBA_COT_Tipo_Dom_Nro FROM Clientes WHERE Id_Cliente = @Id_Cliente), '     ') 
	SET @REA_Destino_Domicilio_Piso = ISNULL((SELECT Dir_Entrega_Piso FROM Clientes WHERE Id_Cliente = @Id_Cliente AND Nro = @Suc_Destina), '   ')
	SET @REA_Destino_Domicilio_Dto = ISNULL((SELECT Dir_Entrega_Dto FROM Clientes WHERE Id_Cliente = @Id_Cliente), '    ')
	SET @REA_Destino_Domicilio_Barrio = ISNULL((SELECT Dir_Entrega_Barrio FROM Clientes WHERE Id_Cliente = @Id_Cliente), '                              ')
	SET @REA_Destino_Domicilio_CodigoPostal = ISNULL((SELECT CP FROM Clientes WHERE Id_Cliente = @Id_Cliente) , '        ')
	SET @REA_Destino_Domicilio_Localidad = ISNULL((SELECT Localidad_Descrip FROM Clientes WHERE Id_Cliente = @Id_Cliente), '                                                  ')
	SET @REA_Destino_Domicilio_Provincia = ISNULL((SELECT TP.Id_AR_ARBA_COT_TProv FROM Clientes CL, Tab_Provincias TP WHERE CL.Id_Provincia = TP.Id_Provincia AND CL.Id_Cliente = @Id_Cliente), 'C'/*Capital Federal*/)
END

SET @REA_Propio_Destino_Domicilio_Codigo = '                    '

SET @REA_Entrega_Domicilio_Origen = 'NO'

SET @REA_Origen_Cuit = ISNULL(@pEmpresa_Cuit_Origen, '00000000000')

SET @REA_Origen_Razon_Social = ISNULL(@pEmpresa_Razon_Social_Origen, '                                                  ')

SET @REA_Emisor_Tenedor = '0' /*No*/

SET @REA_Origen_Domicilio_Calle = ISNULL(@pEmpresa_Direccion_Origen, '                                        ')

SET @REA_Origen_Domicilio_Numero = '     '

SET @REA_Origen_Domicilio_Comple = 'S/N  '

SET @REA_Origen_Domicilio_Piso = '   '

SET @REA_Origen_Domicilio_Dto = '    '

SET @REA_Origen_Domicilio_Barrio = '                              '

SET @REA_Origen_Domicilio_CodigoPostal = ISNULL(@pEmpresa_Cp_Origen, '        ')

SET @REA_Origen_Domicilio_Localidad = (dbo.CF_xParam('COT_Empr_Dom_Localid'))

SET @REA_Origen_Domicilio_Provincia = (dbo.CF_xParam('COT_Empr_Dom_CodProv'))

SET @REA_Transportista_Cuit = @Transportista_Cuit

SET @REA_Tipo_Recorrido = ' '

SET @REA_Recorrido_Localidad = '                                                  '

SET @REA_Recorrido_Calle = '                                        '

SET @REA_Recorrido_Ruta = '                                        '

SET @REA_Patente_Vehiculo = ISNULL((SELECT Patente_Transporte FROM Cbtes WHERE Id_Trans = @pId_Trans), '       ')

SET @REA_Patente_Acoplado = ISNULL((SELECT Patente_Transporte_Acoplado FROM Cbtes WHERE Id_Trans = @pId_Trans), '       ')

SET @REA_Producto_No_Term_Dev = '1'

SET @REA_Importe = (SELECT RIGHT('00000000000000' + CAST(CAST((ISNULL(Imp_Total,0)) * Cotizacion * 100 AS INT) AS VARCHAR), 14) FROM Cbtes WHERE Id_Trans = @pId_Trans)
/*FIN Asignacion de Variables Archivo*/

/*Asignacion Variable de Retorno*/
SET @Retorno		=	@REA_Tipo_Registro					+ @Delimitador + @REA_Fecha_Emision						+ @Delimitador +
						@REA_Codigo_Unico					+ @Delimitador + @REA_Fecha_Salida_Transporte			+ @Delimitador +
						@REA_Hora_Salida_Transporte			+ @Delimitador + @REA_Sujeto_Generador					+ @Delimitador +
						@REA_Destinatario_Consumidor_Final	+ @Delimitador + @REA_Destinatario_Tipo_Documento		+ @Delimitador +
						@REA_Destinatario_Documento			+ @Delimitador + @REA_Destinatario_Cuit					+ @Delimitador +
						@REA_Destinatario_Razon_Social		+ @Delimitador + @REA_Destinatario_Tenedor				+ @Delimitador +
						@REA_Destino_Domicilio_Calle		+ @Delimitador + @REA_Destino_Domicilio_Numero			+ @Delimitador +
						@REA_Destino_Domicilio_Comple		+ @Delimitador + @REA_Destino_Domicilio_Piso			+ @Delimitador +
						@REA_Destino_Domicilio_Dto			+ @Delimitador + @REA_Destino_Domicilio_Barrio			+ @Delimitador +
						@REA_Destino_Domicilio_CodigoPostal + @Delimitador + @REA_Destino_Domicilio_Localidad		+ @Delimitador +
						@REA_Destino_Domicilio_Provincia	+ @Delimitador + @REA_Propio_Destino_Domicilio_Codigo	+ @Delimitador +
						@REA_Entrega_Domicilio_Origen		+ @Delimitador + @REA_Origen_Cuit						+ @Delimitador +
						@REA_Origen_Razon_Social			+ @Delimitador + @REA_Emisor_Tenedor					+ @Delimitador +
						@REA_Origen_Domicilio_Calle			+ @Delimitador + @REA_Origen_Domicilio_Numero			+ @Delimitador +
						@REA_Origen_Domicilio_Comple		+ @Delimitador + @REA_Origen_Domicilio_Piso				+ @Delimitador +
						@REA_Origen_Domicilio_Dto			+ @Delimitador + @REA_Origen_Domicilio_Barrio			+ @Delimitador +
						@REA_Origen_Domicilio_CodigoPostal	+ @Delimitador + @REA_Origen_Domicilio_Localidad		+ @Delimitador +
						@REA_Origen_Domicilio_Provincia		+ @Delimitador + @REA_Transportista_Cuit				+ @Delimitador +
						@REA_Tipo_Recorrido					+ @Delimitador + @REA_Recorrido_Localidad				+ @Delimitador +
						@REA_Recorrido_Calle				+ @Delimitador + @REA_Recorrido_Ruta					+ @Delimitador +
						@REA_Patente_Vehiculo				+ @Delimitador + @REA_Patente_Acoplado					+ @Delimitador +
						@REA_Producto_No_Term_Dev			+ @Delimitador + @REA_Importe

			
RETURN ISNULL(@retorno, '')
END